#!/usr/bin/env python
# -*- coding: latin1 -*-

from setuptools import setup

ver_dic = {}
version_file = open("loopy/version.py")
try:
    version_file_contents = version_file.read()
finally:
    version_file.close()

exec(compile(version_file_contents, "pyopencl/version.py", 'exec'), ver_dic)

setup(name="loo.py",
      version=ver_dic["VERSION_TEXT"],
      description="A code generator for array-based code on CPUs and GPUs",
      long_description=open("README.rst", "rt").read(),
      classifiers=[
          'Development Status :: 4 - Beta',
          'Intended Audience :: Developers',
          'Intended Audience :: Other Audience',
          'Intended Audience :: Science/Research',
          'License :: OSI Approved :: MIT License',
          'Natural Language :: English',
          'Programming Language :: Python',
          'Topic :: Scientific/Engineering',
          'Topic :: Scientific/Engineering :: Information Analysis',
          'Topic :: Scientific/Engineering :: Mathematics',
          'Topic :: Scientific/Engineering :: Visualization',
          'Topic :: Software Development :: Libraries',
          'Topic :: Utilities',
          ],

      install_requires=[
          "pytools>=2014.2",
          "pyopencl>=2014.1",
          "pymbolic>=2014.1.1",
          "cgen>=2013.1.2",
          "islpy>=2014.2",
          "six"
          ],

      author="Andreas Kloeckner",
      url="http://mathema.tician.de/software/loopy",
      author_email="inform@tiker.net",
      license="MIT",
      packages=[
          "loopy",
          "loopy.codegen",
          "loopy.kernel",
          "loopy.library",
          ],
      )
