# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-12 02:48
from __future__ import unicode_literals

from django.db import migrations, models


def forwards(apps, schema_editor):
    UserStatus = apps.get_model("course", "UserStatus")

    for ustatus in UserStatus.objects.all().select_related("user"):
        user = ustatus.user
        user.editor_mode = ustatus.editor_mode
        user.key_time = ustatus.key_time
        user.sign_in_key = ustatus.sign_in_key
        user.status = ustatus.status
        user.save()


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0006_empty_auth_user'),
    ]

    operations = [
        migrations.AddField(
            model_name='user',
            name='editor_mode',
            field=models.CharField(choices=[(b'default', 'Default'), (b'sublime', b'Sublime text'), (b'emacs', b'Emacs'), (b'vim', b'Vim')], default=b'default', help_text="Which key bindings you prefer when editing larger amounts of text or code. (If you do not understand what this means, leave it as 'Default'.)", max_length=20, verbose_name='Editor mode'),
        ),
        migrations.AddField(
            model_name='user',
            name='institutional_id',
            field=models.CharField(blank=True, max_length=100, null=True, verbose_name='Institutional ID'),
        ),
        migrations.AddField(
            model_name='user',
            name='institutional_id_verified',
            field=models.BooleanField(default=False, help_text="Indicates that this user's institutional ID has been verified as being associated with the individual able to log in to this account.", verbose_name='Institutional ID verified'),
        ),
        migrations.AddField(
            model_name='user',
            name='key_time',
            field=models.DateTimeField(default=None, help_text='The time stamp of the sign in token.', verbose_name='Key time', null=True, blank=True),
        ),
        migrations.AddField(
            model_name='user',
            name='name_verified',
            field=models.BooleanField(default=False, help_text="Indicates that this user's name has been verified as being associated with the individual able to sign in to this account.", verbose_name='Name verified'),
        ),
        migrations.AddField(
            model_name='user',
            name='sign_in_key',
            field=models.CharField(blank=True, db_index=True, help_text='The sign in token sent out in email.', max_length=50, null=True, unique=True, verbose_name='Sign in key'),
        ),
        migrations.AddField(
            model_name='user',
            name='status',
            field=models.CharField(choices=[(b'unconfirmed', 'Unconfirmed'), (b'active', 'Active')], max_length=50, null=True, verbose_name='User status'),
        ),
        migrations.AlterField(
            model_name='user',
            name='email',
            field=models.EmailField(blank=True, max_length=100, verbose_name='email address'),
        ),
        migrations.AlterField(
            model_name='user',
            name='first_name',
            field=models.CharField(blank=True, max_length=100, verbose_name='first name'),
        ),
        migrations.AlterField(
            model_name='user',
            name='last_name',
            field=models.CharField(blank=True, max_length=100, verbose_name='last name'),
        ),
        migrations.RunPython(forwards),
    ]
