# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-11-21 22:43
from __future__ import unicode_literals

from django.db import migrations, models


def set_exam_listed_default(apps, schema_editor):
    Exam = apps.get_model("course", "Exam")

    for exam in Exam.objects.all():
        exam.listed = exam.active
        exam.save()


class Migration(migrations.Migration):

    dependencies = [
        ('course', '0099_alter_gradingopportunity_identifier'),
    ]

    operations = [
        migrations.AddField(
            model_name='exam',
            name='listed',
            field=models.BooleanField(default=True, verbose_name="Listed", help_text='Shown in the list of current exams'),
        ),
        migrations.AlterField(
            model_name='exam',
            name='active',
            field=models.BooleanField(default=True, verbose_name="Active", help_text='Currently active, i.e. may be used to log in via an exam ticket'),
        ),
        migrations.RunPython(set_exam_listed_default),
    ]
