# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2016-01-11 20:15
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('course', '0076_remove_exam_lockdown'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='examticket',
            options={'ordering': ('exam__course', '-creation_time'), 'permissions': (('can_issue_exam_tickets', 'Can issue exam tickets to student'),), 'verbose_name': 'Exam ticket', 'verbose_name_plural': 'Exam tickets'},
        ),
        migrations.AlterField(
            model_name='course',
            name='identifier',
            field=models.CharField(db_index=True, help_text="A course identifier. Alphanumeric with dashes, no spaces. This is visible in URLs and determines the location on your file system where the course's git repository lives. This should *not* be changed after the course has been created without also moving the course's git on the server.", max_length=200, unique=True, validators=[django.core.validators.RegexValidator(b'^(?P<course_identifier>[-a-zA-Z0-9]+)$', message="Identifier may only contain letters, numbers, and hypens ('-').")], verbose_name='Course identifier'),
        ),
        migrations.AlterField(
            model_name='course',
            name='number',
            field=models.CharField(help_text="A human-readable course number/ID for the course (e.g. 'CS123')", max_length=200, null=True),
        ),
    ]
