# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-08-08 22:00
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('course', '0090_add_visitor_and_impersonator_fields_to_fpv'),
    ]

    operations = [
        migrations.AlterField(
            model_name='course',
            name='course_file',
            field=models.CharField(default='course.yml', help_text='Name of a YAML file in the git repository that contains the root course descriptor.', max_length=200, verbose_name='Course file'),
        ),
        migrations.AlterField(
            model_name='course',
            name='events_file',
            field=models.CharField(default='events.yml', help_text='Name of a YAML file in the git repository that contains calendar information.', max_length=200, verbose_name='Events file'),
        ),
        migrations.AlterField(
            model_name='course',
            name='identifier',
            field=models.CharField(db_index=True, help_text="A course identifier. Alphanumeric with dashes, no spaces. This is visible in URLs and determines the location on your file system where the course's git repository lives. This should <em>not</em> be changed after the course has been created without also moving the course's git on the server.", max_length=200, unique=True, validators=[django.core.validators.RegexValidator('^(?P<course_identifier>[-a-zA-Z0-9]+)$', message="Identifier may only contain letters, numbers, and hypens ('-').")], verbose_name='Course identifier'),
        ),
        migrations.AlterField(
            model_name='examticket',
            name='state',
            field=models.CharField(choices=[('valid', 'Valid'), ('used', 'Used'), ('revoked', 'Revoked')], max_length=50, verbose_name='Exam ticket state'),
        ),
        migrations.AlterField(
            model_name='flowaccessexceptionentry',
            name='permission',
            field=models.CharField(choices=[('view', 'View the flow'), ('submit_answer', 'Submit answers'), ('end_session', 'End session'), ('change_answer', 'Change already-graded answer'), ('see_correctness', 'See whether an answer is correct'), ('see_answer_before_submission', 'See the correct answer before answering'), ('see_answer_after_submission', 'See the correct answer after answering'), ('cannot_see_flow_result', 'Cannot see flow result'), ('set_roll_over_expiration_mode', "Set the session to 'roll over' expiration mode"), ('see_session_time', 'See session time'), ('lock_down_as_exam_session', 'Lock down as exam session')], max_length=50, verbose_name='Permission'),
        ),
        migrations.AlterField(
            model_name='flowruleexception',
            name='kind',
            field=models.CharField(choices=[('start', 'Session Start'), ('access', 'Session Access'), ('grading', 'Grading')], max_length=50, verbose_name='Kind'),
        ),
        migrations.AlterField(
            model_name='flowsession',
            name='expiration_mode',
            field=models.CharField(choices=[('end', 'Submit session for grading'), ('roll_over', 'Do not submit session for grading')], default='end', max_length=20, null=True, verbose_name='Expiration mode'),
        ),
        migrations.AlterField(
            model_name='flowsession',
            name='participation',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='flow_sessions', to='course.Participation', verbose_name='Participation'),
        ),
        migrations.AlterField(
            model_name='gradechange',
            name='attempt_id',
            field=models.CharField(blank=True, default='main', help_text="Grade changes are grouped by their 'attempt ID' where later grades with the same attempt ID supersede earlier ones.", max_length=50, null=True, verbose_name='Attempt ID'),
        ),
        migrations.AlterField(
            model_name='gradechange',
            name='state',
            field=models.CharField(choices=[('grading_started', 'Grading started'), ('graded', 'Graded'), ('retrieved', 'Retrieved'), ('unavailable', 'Unavailable'), ('extension', 'Extension'), ('report_sent', 'Report sent'), ('do_over', 'Do-over'), ('exempt', 'Exempt')], max_length=50, verbose_name='State'),
        ),
        migrations.AlterField(
            model_name='gradingopportunity',
            name='aggregation_strategy',
            field=models.CharField(choices=[('max_grade', 'Use the max grade'), ('avg_grade', 'Use the avg grade'), ('min_grade', 'Use the min grade'), ('use_earliest', 'Use the earliest grade'), ('use_latest', 'Use the latest grade')], max_length=20, verbose_name='Aggregation strategy'),
        ),
        migrations.AlterField(
            model_name='participation',
            name='role',
            field=models.CharField(choices=[('instructor', 'Instructor'), ('ta', 'Teaching Assistant'), ('student', 'Student'), ('observer', 'Observer'), ('auditor', 'Auditor')], help_text='Instructors may update course content. Teaching assistants may access and change grade data. Observers may access analytics. Each role includes privileges from subsequent roles.', max_length=50, verbose_name='Participation role'),
        ),
        migrations.AlterField(
            model_name='participation',
            name='status',
            field=models.CharField(choices=[('requested', 'Requested'), ('active', 'Active'), ('dropped', 'Dropped'), ('denied', 'Denied')], max_length=50, verbose_name='Participation status'),
        ),
        migrations.AlterField(
            model_name='participationpreapproval',
            name='role',
            field=models.CharField(choices=[('instructor', 'Instructor'), ('ta', 'Teaching Assistant'), ('student', 'Student'), ('observer', 'Observer'), ('auditor', 'Auditor')], max_length=50, verbose_name='Role'),
        ),
    ]
