# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'Pytato'
copyright = '2020, Andreas Klöckner, Matt Wala, Xiaoyu Wei'
author = 'Andreas Klöckner, Matt Wala, Xiaoyu Wei'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',
    'sphinx.ext.mathjax',
    'sphinx_autodoc_typehints',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'alabaster'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []

intersphinx_mapping = {
    'http://docs.python.org/': None,
    'http://documen.tician.de/boxtree/': None,
    'http://docs.scipy.org/doc/numpy/': None,
    'http://documen.tician.de/meshmode/': None,
    'http://documen.tician.de/modepy/': None,
    'http://documen.tician.de/pyopencl/': None,
    'http://documen.tician.de/pytools/': None,
    'http://documen.tician.de/pymbolic/': None,
    'http://documen.tician.de/loopy/': None,
    'http://documen.tician.de/sumpy/': None,
    'http://documen.tician.de/islpy/': None,
    }
