# Copyright (C) 2019 Timothy A. Smith
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

import numpy as np
import numpy.linalg as la  # noqa: F401
import pyopencl as cl  # noqa: F401
import pyopencl.array  # noqa
import pyopencl.tools  # noqa
import pyopencl.clrandom  # noqa
import loopy as lp  # noqa


ndim = 3
nvars = 3
gamma = 1.4


def rho(state):
    return state[0]


def velocity(state):
    return state[1:ndim+1]/rho(state)


def energy(state):
    return state[ndim+1]


def kinetic_energy(state):
    vel = velocity(state)
    return 0.5*rho(state)*np.dot(vel, vel)


def internal_energy(state):
    return energy(state) - kinetic_energy(state)


def pressure(state):
    return (gamma - 1)*internal_energy(state)


def sound_speed(state):
    return np.sqrt(gamma*pressure(state)/rho(state))


def flux(state):
    vel = velocity(state)
    p = pressure(state)

    result = np.outer(state, vel)

    for i in range(ndim):
        result[i+1,i] += p
        result[ndim+1,i] += vel[i]*p

    return result
