import numpy as np


class FluxDerivativeParams:
    def __init__(self, nvars, ndim, nx, ny, nz):
        self.nvars = nvars
        self.ndim = ndim
        self.nx = nx
        self.ny = ny
        self.nz = nz


class FluxDerivativeArrays:
    def __init__(self, states, fluxes, metrics, metric_jacobians):
        self.states = states
        self.fluxes = fluxes
        self.metrics = metrics
        self.metric_jacobians = metric_jacobians


def random_array(*shape):
    return np.random.random_sample(shape).astype(np.float32).copy(order="F")
