import sys
import logging

import pytest
from pyopencl.tools import (  # noqa
        pytest_generate_tests_for_pyopencl
        as pytest_generate_tests)

import comparison_fixtures as compare
import setup_fixtures as setup
import kernel_fixtures as kernel


def test_matvec(ctx_factory):
    a = setup.random_array(10, 10)
    b = setup.random_array(10)

    c = kernel.mult_mat_vec(ctx_factory, a=a, b=b, alpha=1.0)

    compare.arrays(a@b, c)


def test_compute_flux_derivatives(ctx_factory):
    params = setup.FluxDerivativeParams(ndim=3, nvars=5, nx=10, ny=10, nz=10)
    arrays = setup.random_flux_derivative_arrays(params)

    kernel.compute_flux_derivatives(ctx_factory, params, arrays)


def test_compute_flux_derivatives_gpu(ctx_factory):
    params = setup.FluxDerivativeParams(ndim=3, nvars=5, nx=10, ny=10, nz=10)
    arrays = setup.random_flux_derivative_arrays_on_device(ctx_factory, params)

    kernel.compute_flux_derivatives_gpu(ctx_factory, params, arrays)


# This lets you run 'python test.py test_case(cl._csc)' without pytest.
if __name__ == "__main__":
    if len(sys.argv) > 1:
        logging.basicConfig(level="INFO")
        exec(sys.argv[1])
    else:
        pytest.main([__file__])
