import pytest
import utilities as u


class FluxDataSingle:
    nvars = 5
    ndim = 3
    dirs = {"x": 1, "y": 2, "z": 3}

    def __init__(self, states_str, fluxes_str, lam_str, direction):
        self.state_pair = u.transposed_array_from_string(states_str)
        self.states = u.expand_to_6(self.state_pair)
        self.flux_pair = u.transposed_array_from_string(fluxes_str)

        self.lam_pointwise = u.expand_to_6(
                u.transposed_array_from_string(lam_str))

        self.direction = self.dirs[direction]


single_data = {}
single_data["Case a:x"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 11.2 8 8 46.4,1 2.6 1 1 7.1",
        ("2. 2. 2. 3.4966629547095764 0.5033370452904236,"
            "1. 1. 1. 2.4966629547095764 -0.49666295470957644"),
        "x")
single_data["Case a:y"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 8 11.2 8 46.4,1 1 2.6 1 7.1",
        ("2. 2. 2. 3.4966629547095764 0.5033370452904236,"
            "1. 1. 1. 2.4966629547095764 -0.49666295470957644"),
        "y")
single_data["Case a:z"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 8 8 11.2 46.4,1 1 1 2.6 7.1",
        ("2. 2. 2. 3.4966629547095764 0.5033370452904236,"
            "1. 1. 1. 2.4966629547095764 -0.49666295470957644"),
        "z")
single_data["Case b:x"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 2.6 1 1 -7.1,-4 11.2 8 8 -46.4",
        ("-1. -1. -1. 0.49666295470957644 -2.4966629547095764,"
            "-2. -2. -2. -0.5033370452904236 -3.4966629547095764"),
        "x")
single_data["Case b:y"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 1 2.6 1 -7.1,-4 8 11.2 8 -46.4",
        ("-1. -1. -1. 0.49666295470957644 -2.4966629547095764,"
            "-2. -2. -2. -0.5033370452904236 -3.4966629547095764"),
        "y")
single_data["Case b:z"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 1 1 2.6 -7.1,-4 8 8 11.2 -46.4",
        ("-1. -1. -1. 0.49666295470957644 -2.4966629547095764,"
            "-2. -2. -2. -0.5033370452904236 -3.4966629547095764"),
        "z")
single_data["Case c:x"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "4 11.2 16 24 134.4,1 2.6 2 3 12.6",
        ("2. 2. 2. 3.4966629547095764 0.5033370452904236,"
            "1. 1. 1. 2.4966629547095764 -0.49666295470957644"),
        "x")
single_data["Case c:y"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "8 16 35.2 48 268.8,2 2 5.6 6 25.2",
        ("4. 4. 4. 5.496662954709576 2.5033370452904236,"
            "2. 2. 2. 3.4966629547095764 0.5033370452904236"),
        "y")
single_data["Case c:z"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "12 24 48 75.2 403.2,3 3 6 10.6 37.8",
        ("6. 6. 6. 7.496662954709576 4.503337045290424,"
            "3. 3. 3. 4.496662954709576 1.5033370452904236"),
        "z")
single_data["Case d:x"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-1 2.6 2 3 -12.6,-4 11.2 16 24 -134.4",
        ("-1. -1. -1. 0.49666295470957644 -2.4966629547095764,"
            "-2. -2. -2. -0.5033370452904236 -3.4966629547095764"),
        "x")
single_data["Case d:y"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-2 2 5.6 6 -25.2,-8 16 35.2 48 -268.8",
        ("-2. -2. -2. -0.5033370452904236 -3.4966629547095764,"
            "-4. -4. -4. -2.5033370452904236 -5.496662954709576"),
        "y")
single_data["Case d:z"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-3 3 6 10.6 -37.8,-12 24 48 75.2 -403.2",
        ("-3. -3. -3. -1.5033370452904236 -4.496662954709576,"
            "-6. -6. -6. -4.503337045290424 -7.496662954709576"),
        "z")


@pytest.fixture(scope="session", params=[
    "Case a:x",# "Case a:y", "Case a:z",
    "Case b:x",# "Case b:y", "Case b:z",
    "Case c:x",# "Case c:y", "Case c:z",
    "Case d:x"])#, "Case d:y", "Case d:z"])
def data(request):
    return single_data[request.param]


