import numpy as np
from pytest import approx


def arrays(a, b):
    assert a == approx(b)


def roe_identity(states, R, Rinv):
    dState = states[:,1] - states[:,0]
    arrays(R@(Rinv@dState), dState)


def roe_property(states, fluxes, R, Rinv, lam):
    dState = states[:,1] - states[:,0]
    dFlux = fluxes[:,1] - fluxes[:,0]

    temp = Rinv@dState
    temp = np.multiply(lam, temp)
    arrays(R@temp, dFlux)
