# PSAAP3 WENO

Standalone Fortran WENO code with Loopy transformations.

## Notes

* The WENO scheme is taken from [1]
* The Roe matrix implementation follows the internal PlasCom2 documentation
* Boundary conditions are not really handled correctly at all
* A declaration of "real" is not intended to suggest single precision
* This implementation does not include the severe shock correction proposed
    by [1]
* Current assumption for metrics is that metrics(i,j) = (\xi_i)_(x_j)
* It's not immediately obvious, but there might be some wasted work in the
    frozen generalized flux computation
* Right now the specific gas constant gamma is implemented as a magic number
    (1.4) -- this should be generalized

## Fortran dialect wishlist

- Automatic line continuation in parentheses
- Array-valued expressions
- In-place operators
- Slicing that automatically picks an increment of -1 when appropriate
  - (e.g. 2:0 instead of 2:0:-1)
- Scalars with intent(out)

Note: Tag 'nice' references the code at a point where several of these items are used

## Testing plan

Plan to test the following routines directly:

- `compute_flux_derivatives`
- `convert_to_generalized`
- `convert_to_generalized_frozen`
- `convert_from_generalized`
- `roe_eigensystem`
- `pointwise_eigenvalues`
- `lax_wavespeeds`
- `split_characteristic_fluxes`
- `weno_flux`
- `consistent_part`
- `dissipation_part_pos`
- `dissipation_part_neg`

## References

[1] Nonomura, T., Terakado, D., Abe, Y., & Fujii, K. (2015).
*A new technique for freestream preservation of finite-difference WENO on curvilinear grid.*
Computers and Fluids, 107, 242–255.
