
subroutine compute_flux_derivatives(states, fluxes, flux_derivatives)
  real, intent(in) :: states(nvars, nx, ny, nz)
  real, intent(in) :: fluxes(nvars, nx, ny, nz)
  real, intent(in) :: metrics(ndim, ndim, nx, ny, nz)
  real, intent(in) :: metric_jacobians(nx, ny, nz)
  real, intent(out) :: flux_derivatives(ndim, nx, ny, nz)

  ! grid spacing in generalized coordinates
  delta_xi = 1.0
  delta_eta = 1.0
  delta_zeta = 1.0

  flux_derivatives_generalized = 0.0

  do k=1,nz
    do j=1,ny
      do i=0,nx
        call weno_flux(states(:, i-2:i+3, j, k),
                       fluxes(:, i-2:i+3, j, k),
                       metrics(:, :, i-2:i+3, j, k),
                       metric_jacobians(i-2:i+3, j, k),
                       flux)

        flux_derivatives_generalized(1, i, j, k) += flux / delta_xi
        flux_derivatives_generalized(1, i+1, j, k) -= flux / delta_xi
      end do
    end do
  end do

  ! two more loops:
  !   j is inner index, filling flux_derivatives_generalized(2,:,:,:)
  !   k is inner index, filling flux_derivatives_generalized(3,:,:,:)

  call convert_from_generalized(flux_derivatives_generalized,
                                metrics,
                                metric_jacobians,
                                flux_derivatives)
end subroutine

subroutine weno_flux(states, fluxes, metrics, metric_jacobians, flux)
  real, intent(in) :: states(nvars, -2:3)
  real, intent(in) :: fluxes(nvars, -2:3)
  real, intent(in) :: metrics(ndim, ndim, -2:3)
  real, intent(in) :: metric_jacobians(-2:3)
  real, intent(out) :: flux

  call consistent_part(fluxes, metrics, metric_jacobians, consistent)
  call dissipation_part_pos(states, fluxes, metrics, metric_jacobians, dissipation_pos)
  call dissipation_part_neg(states, fluxes, metrics, metric_jacobians, dissipation_neg)

  flux = consistent + dissipation_pos + dissipation_neg
end subroutine

subroutine consistent_part(fluxes, metrics, metric_jacobians, consistent)
  call convert_to_generalized(fluxes, metrics, metric_jacobians, generalized_fluxes)

  consistent = sum([1, -8, 37, 37, -8, 1]*generalized_fluxes)/60
end subroutine

subroutine convert_to_generalized(fluxes,
                                  metrics,
                                  metric_jacobians,
                                  generalized_fluxes)
  real, intent(in) :: fluxes(nvars, -2:3)
  real, intent(in) :: metrics(ndim, ndim, -2:3)
  real, intent(in) :: metric_jacobians(-2:3)
  real, intent(out) :: generalized_fluxes(-2:3)

  ! transforms fluxes from physical coordinates to generalized coordinates
  ! uses metrics at each point
end subroutine

subroutine dissipation_part_pos(states, fluxes, metrics, metric_jacobians, dissipation_pos)
end subroutine

subroutine dissipation_part_neg(states, fluxes, metrics, metric_jacobians, dissipation_neg)
end subroutine

subroutine convert_from_generalized(flux_derivatives_generalized,
                                    metrics,
                                    metric_jacobians,
                                    flux_derivatives)
  ! transforms flux derivatives from generalized coordinates to physical coordinates
end subroutine
