import pytest
import utilities as u


class FluxDataSingle:
    nvars = 5
    ndim = 3
    dirs = {"x": 1, "y": 2, "z": 3}

    def __init__(self, states_str, fluxes_str, direction):
        self.states = u.transposed_array_from_string(states_str)
        self.fluxes = u.transposed_array_from_string(fluxes_str)
        self.direction = self.dirs[direction]


uniformData = {}
uniformData["Case a:x"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 11.2 8 8 46.4,1 2.6 1 1 7.1",
        "x")
uniformData["Case a:y"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 8 11.2 8 46.4,1 1 2.6 1 7.1",
        "y")
uniformData["Case a:z"] = FluxDataSingle(
        "2 4 4 4 20,1 1 1 1 5.5",
        "4 8 8 11.2 46.4,1 1 1 2.6 7.1",
        "z")
uniformData["Case b:x"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 2.6 1 1 -7.1,-4 11.2 8 8 -46.4",
        "x")
uniformData["Case b:y"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 1 2.6 1 -7.1,-4 8 11.2 8 -46.4",
        "y")
uniformData["Case b:z"] = FluxDataSingle(
        "1 -1 -1 -1 5.5,2 -4 -4 -4 20",
        "-1 1 1 2.6 -7.1,-4 8 8 11.2 -46.4",
        "z")
uniformData["Case c:x"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "4 11.2 16 24 134.4,1 2.6 2 3 12.6",
        "x")
uniformData["Case c:y"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "8 16 35.2 48 268.8,2 2 5.6 6 25.2",
        "y")
uniformData["Case c:z"] = FluxDataSingle(
        "2 4 8 12 64,1 1 2 3 11",
        "12 24 48 75.2 403.2,3 3 6 10.6 37.8",
        "z")
uniformData["Case d:x"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-1 2.6 2 3 -12.6,-4 11.2 16 24 -134.4",
        "x")
uniformData["Case d:y"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-2 2 5.6 6 -25.2,-8 16 35.2 48 -268.8",
        "y")
uniformData["Case d:z"] = FluxDataSingle(
        "1 -1 -2 -3 11,2 -4 -8 -12 64",
        "-3 3 6 10.6 -37.8,-12 24 48 75.2 -403.2",
        "z")


@pytest.fixture(scope="session", params=[
    "Case a:x", "Case a:y", "Case a:z",
    "Case b:x", "Case b:y", "Case b:z",
    "Case c:x", "Case c:y", "Case c:z",
    "Case d:x", "Case d:y", "Case d:z"])
def data(request):
    return uniformData[request.param]


