# setup to mark slow tests with @pytest.mark.slow, so that they don't run by
# default, but can be forced to run with the command-line option --runslow
# taken from
# https://docs.pytest.org/en/latest/example/simple.html#control-skipping-of-tests-according-to-command-line-option

import pytest


def pytest_addoption(parser):
    parser.addoption("--runslow", action="store_true", default=False,
            help="run slow tests")


def pytest_collection_modifyitems(config, items):
    if config.getoption("--runslow"):
        # --runslow given in cli: do not skip slow tests
        return
    skip_slow = pytest.mark.skip(reason="need --runslow option to run")
    for item in items:
        if "slow" in item.keywords:
            item.add_marker(skip_slow)
