__copyright__ = "Copyright (C) 2019 Timothy A. Smith"

__license__ = """
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

import numpy as np
import numpy.linalg as la  # noqa: F401
import pyopencl as cl  # noqa: F401
import pyopencl.array  # noqa
import pyopencl.tools  # noqa
import pyopencl.clrandom  # noqa
import loopy as lp  # noqa

import sys
import logging

import pytest

import utilities as u
from data_for_test import (  # noqa: F401
        cfd_test_data_fixture
        )


def test_compute_flux_derivatives_uniform_grid(queue, cfd_test_data_fixture):
    data = cfd_test_data_fixture

    prg = u.get_weno_program()
    prg = prg.copy(target=lp.PyOpenCLTarget(queue.device))

    flux_derivatives_dev = u.empty_array_on_device(queue, *data.flux_dims)

    prg(queue,
            nvars=data.nvars,
            ndim=data.ndim,
            nx=data.nx,
            ny=data.ny,
            nz=data.nz,
            d=data.direction,
            states=data.states,
            fluxes=data.fluxes,
            metrics=data.metrics,
            metric_jacobians=data.jacobians,
            flux_derivatives=flux_derivatives_dev)

    u.compare_arrays(flux_derivatives_dev.get(), data.flux_derivatives)


# This lets you run 'python test.py test_case(cl._csc)' without pytest.
if __name__ == "__main__":
    if len(sys.argv) > 1:
        logging.basicConfig(level="INFO")
        exec(sys.argv[1])
    else:
        pytest.main([__file__])
