echo "-----------------------------------------------"
echo "Current directory: $(pwd)"
echo "Python executable: ${PY_EXE}"
echo "PYOPENCL_TEST: ${PYOPENCL_TEST}"
echo "PYTEST_ADDOPTS: ${PYTEST_ADDOPTS}"
echo "PROJECT_INSTALL_FLAGS: ${PROJECT_INSTALL_FLAGS}"
echo "git revision: $(git rev-parse --short HEAD)"
echo "git status:"
git status -s
echo "-----------------------------------------------"

# {{{ clean up

rm -Rf .env
rm -Rf build
find . -name '*.pyc' -delete

rm -Rf env
git clean -fdx \
  -e siteconf.py \
  -e boost-numeric-bindings \
  -e '.pylintrc.yml' \
  -e 'prepare-and-run-*.sh' \
  -e 'run-*.py' \
  $GIT_CLEAN_EXCLUDE

# }}}

if [[ "$NO_SUBMODULES" = "" ]]; then
  git submodule update --init --recursive
fi

# {{{ virtualenv

VIRTUALENV="${PY_EXE} -m venv"

if [ -d ".env" ]; then
  echo "**> virtualenv exists"
else
  echo "**> creating virtualenv"
  ${VIRTUALENV} .env
fi

. .env/bin/activate

# }}}

$PY_EXE -m ensurepip

PIP="${PY_EXE} $(which pip)"

# https://github.com/pypa/pip/issues/5345#issuecomment-386443351
export XDG_CACHE_HOME=$HOME/.cache/$CI_RUNNER_ID

$PIP install --upgrade pip
$PIP install setuptools

$PIP install pytest

if test "$EXTRA_INSTALL" != ""; then
  for i in $EXTRA_INSTALL ; do
    if [ "$i" = "numpy" ] && [[ "${PY_EXE}" == pypy* ]]; then
      $PIP install git+https://bitbucket.org/pypy/numpy.git
    elif [[ "$i" = *pybind11* ]] && [[ "${PY_EXE}" == pypy* ]]; then
      # Work around https://github.com/pypa/virtualenv/issues/1198
      # Running virtualenv --always-copy or -m venv --copies should also do the trick.
      L=$(readlink .env/include)
      rm .env/include
      cp -R $L .env/include

      $PIP install $i
    elif [ "$i" = "numpy" ] && [[ "${PY_EXE}" == python2.6* ]]; then
      $PIP install 'numpy==1.10.4'
    else
      $PIP install $i
    fi
  done
fi

if test "$REQUIREMENTS_TXT" == ""; then
  REQUIREMENTS_TXT="requirements.txt"
fi

if test -f $REQUIREMENTS_TXT; then
  $PIP install -r $REQUIREMENTS_TXT
fi

${PY_EXE} -m pytest -rw --durations=10 --tb=native --junitxml=pytest.xml -rxsw --runslow test

# vim: foldmethod=marker
